#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>
#include <bitset>

using namespace std;

const int MAXN = 20 * 1000 + 5, MAXM = 100 * 1000 + 5, INF = 2000 * 1000 * 1000 + 5;
int d[MAXN], pos[MAXN];
char used[MAXN], col0[MAXN], col1[MAXN], br[MAXN];
vector< pair<int, pair<int, int> > > g[MAXN];
set< pair<int, int> > st;
vector<int> ts, ans;

void dfs0(int v) {
    used[v] = true;
    col0[v] = true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first;
        if(!used[u] && d[u] + w == d[v])
            dfs0(u);
    }
}

void dfs1(int v) {
    used[v] = true;
    col1[v] = true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first;
        if(!used[u] && d[v] + w == d[u])
            dfs1(u);
    }
}

void topsort(int v) {
    used[v] = true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first;
        if(!used[u] && d[v] + w == d[u])
            topsort(u);
    }
    ts.push_back(v);
}

int main() {
    ios_base::sync_with_stdio(false);
    int n, m;
    cin >> n >> m;
    for(int i = 0; i < m; i++) {
        int v, u, w;
        cin >> v >> u >> w;
        v--;
        u--;
        g[v].push_back(make_pair(u, make_pair(w, i)));
        g[u].push_back(make_pair(v, make_pair(w, i)));
    }
    for(int i = 0; i < n; i++)
        d[i] = INF;
    d[0] = 0;
    st.insert(make_pair(d[0], 0));
    while(!st.empty()) {
        int v = st.begin()->second;
        st.erase(st.begin());
        for(size_t i = 0; i < g[v].size(); i++) {
            int u = g[v][i].first, w = g[v][i].second.first;
            if(d[v] + w < d[u]) {
                st.erase(make_pair(d[u], u));
                d[u] = d[v] + w;
                st.insert(make_pair(d[u], u));
            }
        }
    }
    dfs0(n - 1);
    for(int i = 0; i < n; i++)
        used[i] = false;
    dfs1(0);
    for(int i = 0; i < n; i++)
        used[i] = false;
    topsort(0);
    reverse(ts.begin(), ts.end());
    for(size_t i = 0; i < ts.size(); i++)
        pos[ts[i]] = i;
    int maxe = -1;
    for(size_t i = 0; i < ts.size(); i++) {
        int v = ts[i];
        if(!col0[v] || !col1[v])
            continue;
        int cnt = 0;
        for(size_t j = 0; j < g[v].size(); j++) {
            int u = g[v][j].first, w = g[v][j].second.first, id = g[v][j].second.second;
            if(!col0[u] || !col1[u] || d[v] + w != d[u])
                continue;
            cnt++;
        }
        if(cnt == 1 && maxe <= i) {
            for(size_t j = 0; j < g[v].size(); j++) {
                int u = g[v][j].first, w = g[v][j].second.first, id = g[v][j].second.second;
                if(!col0[u] || !col1[u] || d[v] + w != d[u])
                    continue;
                ans.push_back(id);
                maxe = max(maxe, pos[u]);
                break;
            }
        }
        else {
            for(size_t j = 0; j < g[v].size(); j++) {
                int u = g[v][j].first, w = g[v][j].second.first, id = g[v][j].second.second;
                if(!col0[u] || !col1[u] || d[v] + w != d[u])
                    continue;
                maxe = max(maxe, pos[u]);
            }
        }
    }
    cout << ans.size() << '\n';
    for(size_t i = 0; i < ans.size(); i++)
        cout << ans[i] + 1 << ' ';
    cout << '\n';
    return 0;
}
